/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"
#include "GameSpy.h"
#include "time.h"

std::vector<std::string> Config::ExtraStringList;
std::string Config::CustomGameTitle, Config::GameMode, Config::PlayerTimeMode, Config::GameTitle;
bool Config::ShowGameMode, Config::ShowDriverGunner, Config::ShowTeamChanging, Config::UseTotalPlayerTime, Config::NoWOLAppendPlayerCount, 
Config::ShowFriendlyFire, Config::ShowCredits, Config::ShowTimeLeft, Config::ShowPedestal, Config::ShowRotation;
int Config::MaxPlayers, Config::ListenPort;
ExampleSettingsStruct *ExampleSettings = 0;

void ExampleSettingsStruct::Load() 
{
	SettingsLoader::Load();

	LoadList(ExtraStringList,"ExtraStrings");
	std::copy(  ExtraStringList.begin(), ExtraStringList.end(), std::back_inserter( Config::ExtraStringList ) );
	Config::ExtraStringList.push_back("\0");

	LoadInt(ListenPort, "ListenPort");
	LoadInt(MaxPlayers, "MaxPlayers");
	LoadSString(CustomGameTitle, "CustomGameTitle");
	LoadSString(GameMode, "GameMode");
	LoadBool(ShowGameMode, "ShowGameMode");
	LoadBool(ShowDriverGunner, "ShowDriverGunner");
	LoadBool(ShowTeamChanging, "ShowTeamChanging");
	LoadBool(ShowFriendlyFire, "ShowFriendlyFire");
	LoadBool(ShowCredits, "ShowCredits");
	LoadBool(ShowTimeLeft, "ShowTimeLeft");
	LoadBool(ShowPedestal, "ShowPedestal");
	LoadBool(ShowRotation, "ShowRotation");
	LoadSString(PlayerTimeMode, "PlayerTimeMode");
	NoWOLAppendPlayerCount = false;
	LoadBool(NoWOLAppendPlayerCount, "NoWOLAppendPlayerCount");
	
	Config::ListenPort = ListenPort;
	Config::MaxPlayers = MaxPlayers;
	Config::CustomGameTitle = CustomGameTitle;
	Config::GameMode = GameMode;
	Config::ShowGameMode = ShowGameMode;
	Config::ShowDriverGunner = ShowDriverGunner;
	Config::ShowTeamChanging = ShowTeamChanging;
	Config::ShowFriendlyFire = ShowFriendlyFire;
	Config::ShowCredits = ShowCredits;
	Config::ShowTimeLeft = ShowTimeLeft;
	Config::ShowPedestal = ShowPedestal;
	Config::ShowRotation = ShowRotation;
	Config::PlayerTimeMode = PlayerTimeMode;
	Config::NoWOLAppendPlayerCount = NoWOLAppendPlayerCount;
	Config::GameTitle = WideCharToChar(The_Game()->GameTitle.Peek_Buffer());

	Config::UseTotalPlayerTime = false;
	if ( Config::PlayerTimeMode == "Total" || Config::PlayerTimeMode == "total" )
	{
		Config::UseTotalPlayerTime = true;
	}
	else if( Config::PlayerTimeMode == "Gamestart" || Config::PlayerTimeMode == "gamestart" )
	{
		Config::UseTotalPlayerTime = false;
	}
}


int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;


void ObjectHookCall(void *data,GameObject *obj) {
}

void Plugin_Load() {
	ExampleSettings = new ExampleSettingsStruct("gamespy_support.ini");
	ExampleSettings->Load();

	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);
	GameSpy::StartUp();
	CreateThread(NULL, NULL, Do_GameSpy_Heart_Beat, NULL, NULL, NULL);

	if ( !Config::NoWOLAppendPlayerCount )
	{
		CreateThread(NULL, NULL, Set_Player_Count_Game_Title, NULL, NULL, NULL);
	}
}

void Plugin_Unload() {
	delete ExampleSettings;
	delete ObjectHookStruct;
}

DWORD WINAPI Do_GameSpy_Heart_Beat(LPVOID params)
{
	for (;;)
	{		
		GameSpy::DoHeartBeat();
		Sleep(300000);
	}
	return 0;
}




DWORD WINAPI Set_Player_Count_Game_Title(LPVOID params)
{
	char tmp[128];
	for (;;)
	{
		memset(tmp, 0x0, 128);		
		sprintf(tmp, "%s (%d/%d)", Config::GameTitle.c_str(), The_Game()->CurrentPlayers, The_Game()->MaxPlayers);
		const wchar_t *Data = CharToWideChar(tmp);
		The_Game()->GameTitle = Data;
		delete []Data;
		Sleep(5000);
	}
	return 0;
}

extern "C" {

DLLEXPORT void SSGM_Player_Join_Hook(int ID, const char *Nick) 
{
	GameSpy::SetJoinTime(ID, time(NULL));
}

DLLEXPORT void SSGM_Player_Leave_Hook(int ID) 
{
	GameSpy::SetJoinTime(ID, 0);
}
}

